<?php

namespace App\Http\Resources;

use App\Models\SalesOrderFulfillment;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/**
 * Class SalesOrderFulfillmentResource.
 *
 *
 * @mixin SalesOrderFulfillment
 */
class SalesOrderFulfillmentResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'fulfillment_number' => $this->fulfillment_number,
            'sales_order_id' => $this->sales_order_id,
            'fulfillment_type' => $this->fulfillment_type,
            'fulfillment_status' => $this->status,
            'shipping_method_id' => $this->requested_shipping_method_id,
            'shipping_method' => $this->whenLoaded('requestedShippingMethod', function () {
                return $this->requestedShippingMethod->full_name;
            }),
            'requested_shipping_method' => $this->requested_shipping_method,
            'requested_shipping_method_id' => $this->requested_shipping_method_id,
            'requested_shipping_method_name' => $this->whenLoaded('requestedShippingMethod', function () {
                return $this->requestedShippingMethod->full_name;
            }),
            'fulfilled_shipping_method' => $this->fulfilled_shipping_method,
            'fulfilled_shipping_method_id' => $this->fulfilled_shipping_method_id,
            'fulfilled_shipping_method_name' => $this->whenLoaded('fulfilledShippingMethod', function () {
                return $this->fulfilledShippingMethod->full_name;
            }),
            'fulfilled_date' => $this->fulfilled_at ?? $this->metadata['shipment-date'] ?? null,
            'tracking_number' => $this->tracking_number,
            'tracking_link' => $this->tracking_link,
            'warehouse' => $this->warehouse->only('id', 'name'),
            'fulfilled_by' => $this->user_id ? $this->user->only('id', 'name') : null,
            'fulfilled_quantity' => $this->salesOrderFulfillmentLines->sum('quantity'),
            'fulfillment_lines' => SalesOrderFulfillmentLineResource::collection($this->salesOrderFulfillmentLines),
            'cost' => $this->cost,
            'status' => $this->status,
            'fulfilled_at' => $this->fulfilled_at ?? $this->metadata['shipment-date'] ?? null,
            'packing_slip_printed_at' => $this->packing_slip_printed_at,
            'metadata' => $this->metadata,
            'fulfillment_sequence' => $this->fulfillment_sequence
        ];
    }
}
