<?php

namespace App\Http\Resources;

use App\DataTable\DataTableResource;
use App\Models\Customer;
use Illuminate\Http\Request;

/**
 * Class SalesCustomerAddressResource.
 *
 *
 * @mixin Customer
 */
class SalesCustomerAddressResource extends DataTableResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'customer_name' => $this->inclusive('customer_name', [
                'id' => $this->id,
                'name' => $this->name,
            ]),
            'customer_email' => $this->inclusive('customer_email', $this->email),
            'customer_company' => $this->inclusive('customer_company', $this->address?->company),
            'customer_phone' => $this->inclusive('customer_phone', $this->address?->phone),
            'customer_address' => $this->inclusive('customer_address', $this->address1),
            'customer_city' => $this->inclusive('customer_city', $this->address?->city),
            'customer_province' => $this->inclusive('customer_province', $this->address?->province),
            'customer_province_code' => $this->inclusive('customer_province_code', $this->address?->province_code),
            'customer_zip' => $this->inclusive('customer_zip', $this->zip),
            'customer_country' => $this->inclusive('customer_country', $this->address?->country),
            'customer_country_code' => $this->inclusive('customer_country_code', $this->address?->country_code),
            'customer_product_pricing_tier_id' => $this->product_pricing_tier_id,
            'customer_addresses' => $this->whenLoaded('addresses', function () {
                return $this->addresses->map(function ($address) {
                    return [
                        'id' => $address->id,
                        'name' => $address->name,
                        'company' => $address->company,
                        'phone' => $address->phone,
                        'address1' => $address->address1,
                        'address2' => $address->address2,
                        'city' => $address->city,
                        'province' => $address->province,
                        'province_code' => $address->province_code,
                        'zip' => $address->zip,
                        'country' => $address->country,
                        'country_code' => $address->country_code,
                    ];
                });
            }),
        ];
    }
}
