<?php

namespace App\Http\Resources;

use App\DataTable\DataTableResource;
use App\Models\SalesCreditLine;
use Illuminate\Http\Request;

/**
 * Class SalesCreditLineResource.
 *
 *
 * @mixin SalesCreditLine
 */
class SalesCreditLineResource extends DataTableResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'sales_order_line_id' => $this->inclusive('sales_order_line_id', $this->sales_order_line_id),
            'item_quantity' => $this->inclusive('item_quantity', $this->quantity),
            'item_sku' => $this->inclusive('item_sku', $this->product ? $this->product->only('id', 'sku') : null),
            'item_barcode' => $this->product ? $this->product->barcode : null,
            'item_price' => $this->inclusive('item_price', $this->amount),
            'unit_cost' => $this->inclusive('unit_cost', $this->unit_cost),
            'item_name' => $this->inclusive('item_name', $this->description),
            'item_nominal_code_id' => $this->inclusive('item_nominal_code_id', $this->nominal_code_id),
            'item_nominal_code' => $this->inclusive('item_nominal_code', $this->nominalCode->name ?? null),
            'item_tax_value' => $this->inclusive('item_tax_value', $this->tax_allocation),
            'tax_rate' => $this->inclusive('tax_rate', $this->taxRate),
            'tax_rate_id' => $this->inclusive('tax_rate_id', $this->tax_rate_id),
            'is_product' => $this->inclusive('is_product', $this->is_product),
            'proration' => $this->inclusive('proration', $this->proration),
            'created_at' => $this->inclusive('created_at', $this->created_at),
            'updated_at' => $this->inclusive('updated_at', $this->updated_at),

            $this->mergeWhen($this->relationLoaded('salesCreditReturnLines'), function () {
                return [
                    'is_received' => $this->inclusive('is_received', $this->fully_received),
                    'unreceived_quantity' => $this->inclusive('unreceived_quantity', $this->unreceived_quantity),
                    'receipt_lines' => SalesCreditReturnLineResource::collection($this->salesCreditReturnLines),
                ];
            }),

            $this->mergeWhen($this->product && $this->product->relationLoaded('primaryImage'), function () {
                return ['item_img_url' => $this->inclusive('item_img_url', $this->product->image ?? null)];
            }),
        ];
    }
}
