<?php

namespace App\Http\Resources;

use App\Models\SalesCreditLine;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Http\Resources\MissingValue;

/**
 * Class ReturnReceiptItemResource.
 *
 *
 * @mixin SalesCreditLine
 */
class ReturnReceiptItemResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): MissingValue|array
    {
        if ($this->received_quantity && $this->product_id) {
            return [
                'returns_receipt_items_sku' => $this->product->only(['id', 'sku']),
                'returns_receipt_items_quantity' => $this->received_quantity,
                'returns_receipt_items_reason' => $this->salesCreditReturnLines->first()->returnReason->name,
                'returns_receipt_items_reason_notes' => $this->salesCreditReturnLines->first()->notes,
                'returns_receipt_items_action' => $this->salesCreditReturnLines->first()->action,
            ];
        }

        return new MissingValue();
    }
}
