<?php

namespace App\Http\Resources;

use App\Models\PurchaseOrderShipment;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/**
 * Class PurchaseOrderShipmentResource.
 *
 *
 * @mixin PurchaseOrderShipment
 */
class PurchaseOrderShipmentResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        $this->load('purchaseOrderShipmentReceipts', 'purchaseOrderShipmentReceipts.purchaseOrderShipmentReceiptLines');

        return [
            'id' => $this->id,
            'shipment_date' => $this->shipment_date,
            'shipping_method_id' => $this->fulfilled_shipping_method_id,
            'fulfilled_shipping_method_id' => $this->fulfilled_shipping_method_id,
            'tracking' => $this->tracking,
            'fully_received_at' => $this->fully_received_at,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,

            // lines
            'purchase_order_shipment_lines' => $this->purchaseOrderShipmentLines->map->attributesToArray(),

            // receipts
            'purchase_order_shipment_receipts' => $this->purchaseOrderShipmentReceipts,
        ];
    }
}
