<?php

namespace App\Http\Resources;

use App\Models\PurchaseOrderShipment;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/**
 * @mixin PurchaseOrderShipment
 */
class PurchaseOrderShipmentInfoResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'shipment_shipping_method_id' => $this->fulfilled_shipping_method_id,
            'shipment_shipping_method' => $this->whenLoaded('fulfilledShippingMethod', function () {
                return $this->fulfilledShippingMethod->full_name;
            }),
            'fulfilled_shipping_method' => $this->fulfilled_shipping_method,
            'shipment_item_quantity' => $this->lines_quantity,
            'shipment_item_received' => $this->received_lines_quantity,
            'shipment_date' => $this->shipment_date,
            'shipment_tracking' => $this->tracking,
        ];
    }
}
