<?php

namespace App\Http\Resources;

use App\Models\PurchaseOrderShipmentReceiptLine;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/**
 * Class PurchaseOrderReceiptLineResource.
 *
 * @mixin PurchaseOrderShipmentReceiptLine
 */
class PurchaseOrderReceiptLineResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        $this->load(['purchaseOrderShipmentLine', 'purchaseOrderShipmentLine.purchaseOrderLine']);

        return [
            'id' => $this->id,
            'quantity' => $this->quantity,
            'purchase_order_line' => [
                'id' => $this->purchaseOrderShipmentLine->purchaseOrderLine->id,
                'product' => [
                    'id' => $this->purchaseOrderShipmentLine->purchaseOrderLine->product_id ?? null,
                    'sku' => $this->purchaseOrderShipmentLine->purchaseOrderLine->product->sku ?? null,
                    'supplier_sku' => $this->purchaseOrderShipmentLine->purchaseOrderLine->supplierProduct->supplier_sku ?? null,
                ],
                'description' => $this->purchaseOrderShipmentLine->purchaseOrderLine->description,
                'received_quantity' => $this->purchaseOrderShipmentLine->purchaseOrderLine->received_quantity,
                'quantity' => $this->purchaseOrderShipmentLine->purchaseOrderLine->quantity,
            ],
        ];
    }
}
