<?php

namespace App\Http\Resources;

use App\Models\PurchaseInvoiceLine;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/**
 * Class PurchaseInvoiceLineResource.
 *
 * @mixin PurchaseInvoiceLine
 */
class PurchaseInvoiceLineResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'purchase_invoice_id' => $this->purchase_invoice_id,
            'purchase_order_line_id' => $this->purchase_order_line_id,
            'quantity_invoiced' => $this->quantity_invoiced,
            'purchase_order_line' => PurchaseOrderLineResource::make($this->purchaseOrderLine),
        ];
    }
}
