<?php

namespace App\Http\Resources;

use App\DataTable\DataTableResource;
use App\Models\ProductCategory;
use Illuminate\Http\Request;

/**
 * Class ProductCategoryResource.
 *
 * @mixin ProductCategory
 */
class ProductCategoryResource extends DataTableResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'name' => $this->name,
            'id' => $this->id,
            'parent_name' => $this->inclusive('parent_name', $this->whenLoaded('parent', function () {
                return $this->parent->name ?? null;
            })),
            'parent_id' => $this->parent_id,
            'category_tree' => $this->inclusive('category_tree', $this->whenLoaded('root', function () {
                return $this->root ? $this->root->only('id', 'name') : null;
            })),
            'is_leaf' => $this->inclusive('is_leaf', $this->is_leaf),
            'level' => $this->inclusive('level', $this->level),
            'children_count' => $this->whenLoaded('childrenWithSub', function () {
                return count($this->getSubcategoriesIds()) - 1;
            }),
            'created_at' => $this->inclusive('created_at', $this->created_at),
            'updated_at' => $this->inclusive('updated_at', $this->updated_at),
            'archived_at' => $this->inclusive('archived_at', $this->archived_at),

            // on view category
            'products_ids' => $this->inclusive('products_ids', $this->when(isset($this->category_to_products_ids), $this->category_to_products_ids)),
            'products_count' => $this->inclusive('products_count', $this->when(isset($this->category_to_products_count), $this->category_to_products_count)),
            'subcategories_count' => $this->inclusive('subcategories_count', $this->when(isset($this->subcategories_count), $this->subcategories_count)),
            'attribute_groups_count' => $this->inclusive('attribute_groups_count', $this->when(isset($this->category_to_attribute_groups_count), $this->category_to_attribute_groups_count)),
            'attribute_groups' => $this->inclusive('attribute_groups', $this->whenLoaded('attributeGroups', function () {
                return $this->attributeGroups->map(function ($attributeGroup) {
                    return $attributeGroup->only('name', 'id');
                });
            })),
            'attributes_count' => $this->inclusive('attributes_count', $this->when(isset($this->category_to_attributes_count), $this->category_to_attributes_count)),
            'attributes' => $this->inclusive('attributes', $this->whenLoaded('attributes', function () {
                return $this->attributes->map(function ($attribute) {
                    return $attribute->only('name', 'id', 'type');
                });
            })),
        ];
    }
}
