<?php

namespace App\Http\Resources;

use App\Models\ProductAttribute;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ProductAttributeResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        //    $this->whenPivotLoaded( ProductAttribute::class, function () {
        //      $this->pivot->setValueCast( $this->type );
        //    } );

        //    $this->setValueCast($this->type);

        return [
            'attribute_id' => $this->attribute->id, // Keeping this property for backward compatibility.
            'id' => $this->attribute->id, // ID is necessary
            'name' => $this->attribute->name,
            'type' => $this->attribute->type,
            'display_options' => $this->attribute->display,
            'value' => $this->value ?? null,
            //      'value'           => $this->whenPivotLoaded( ProductAttribute::class, function () {
            //        return $this->pivot->value;
            //      }, null ),
            'validation' => $this->attribute->validation,
            'attribute_group' => $this->when(isset($this->attribute_group), $this->attribute_group),
            'notes' => $this->attribute->notes,
        ];
    }
}
