<?php

namespace App\Http\Resources;

use App\Models\Payment;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/**
 * Class PaymentResource.
 *
 * @mixin Payment
 */
class PaymentResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        $this->loadMissing(['paymentType', 'currency']);

        return [
            'id' => $this->id,
            'amount' => $this->amount,
            'cost' => $this->cost,
            'payment_date' => $this->payment_date,
            'payment_type' => $this->whenLoaded('paymentType', function () {
                return ['id' => $this->payment_type_id, 'name' => $this->paymentType->name];
            }),
            'external_reference' => $this->external_reference,
            'type' => $this->type,
            'currency_code' => $this->whenLoaded('currency', $this->currency->code),
        ];
    }
}
