<?php

namespace App\Http\Resources\Magento;

use App\Models\Magento\Product;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/**
 * Class SalesOrderLineListingShopifyResource.
 *
 * @mixin Product|array
 */
class SalesOrderLineListingMagentoResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        if ($this->resource instanceof Product) {
            return [
                'id' => $this['id'] ?? $this['_id'],
                'unique_sales_channel_product_id' => $this['sku'],
                'skuAlias' => $this['sku'],
                'sku' => $this['sku'],
                'name' => $this['name'],
            ];
        } else {
            return [
                'skuAlias' => $this->resource['sku'],
                'sku' => $this->resource['sku'],
                'name' => $this->resource['name'],
            ];
        }
    }
}
