<?php

namespace App\Http\Resources\Magento;

use App\DataTable\DataTableResource;
use App\Models\Magento\Product;
use Illuminate\Http\Request;

/**
 * @mixin Product
 */
class ProductResource extends DataTableResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray(Request $request): array
    {
        $result = [
            'id' => $this->inclusive('id', $this['id']),
            'variant_id' => $this->inclusive('variant_id', $this['variant_id']),
            'product_listing_id' => $this->inclusive('product_listing_id', $this->productListing?->id),
            'sku' => $this->inclusive('sku', $this['sku']),
            'price' => $this->inclusive('price', $this['price']),
            'name' => $this->inclusive('name', $this['name']),
            'status' => $this->inclusive('status', $this->status_name),
            'weight' => $this->inclusive('weight', $this['weight']),
            'type_id' => $this->inclusive('type_id', $this->json_object['type_id']),
            'product' => $this->inclusive('product', $this->productListing?->product->only('id', 'name', 'sku')),
            'mapped_sku' => $this->inclusive('mapped_sku', $this->productListing?->product->sku),
            'mapped_at' => $this->inclusive('mapped_at', $this->mapped_at),
            'options' => $this->json_object['custom_attributes'] ?? [],
            'created_at' => $this->inclusive('created_at', $this->json_object['created_at']),
            'updated_at' => $this->inclusive('updated_at', $this->json_object['updated_at']),
        ];

        foreach ($result['options'] as $option) {
            $result['attributes.'.strtolower($option['attribute_code'])] = $option['value'];
        }

        return $result + $this->getRequestedImages();
    }

    protected function getRequestedImages(): array
    {
        $images = [];
        for ($i = 0; $i < Product::maxImageCount(); $i++) {
            $field = 'image'.($i + 1);
            $images[$field] = $this->inclusive($field, $this->getImageUrl($this->json_object['media_gallery_entries'][$i]['file'] ?? null));
        }

        return $images;
    }
}
