<?php

namespace App\Http\Resources;

use App\DataTable\DataTableResource;
use App\Models\InventoryMovement;
use Illuminate\Http\Request;

/**
 * Class InventoryMovementResource.
 *
 * @mixin InventoryMovement
 */
class InventoryMovementResource extends DataTableResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'inventory_movement_date' => $this->inclusive('inventory_movement_date', $this->inventory_movement_date),
            'sku' => $this->inclusive('sku', $this->whenLoaded('product', function () {
                return $this->product->sku;
            })),
            'barcode' => $this->inclusive('barcode', $this->whenLoaded('product', function () {
                return $this->product->barcode;
            })),
            'product_name' => $this->inclusive('product_name', $this->whenLoaded('product', function () {
                return $this->product->name;
            })),
            'type' => $this->inclusive('type', [
                'name' => $this->type,
                'link_type' => $this->link_type,
                'link_id' => $this->link_id,
                'parent_link_id' => $this->parent_link_id,
            ]),
            'inventory_status' => $this->inclusive('inventory_status', $this->inventory_status),
            'quantity' => $this->inclusive('quantity', $this->quantity),
            'warehouse' => $this->inclusive('warehouse', $this->whenLoaded('warehouse', function () {
                return $this->warehouse->only('id', 'name');
            })),
            'layer' => $this->inclusive('layer', isset($this->layer_type) ? [
                'layer_type' => $this->layer_type,
                'layer_id' => $this->layer_id,
                'name' => $this->layer_name,
            ] : null),
            'layer_id' => $this->inclusive('layer_id', $this->layer_id),
            'layer_type' => $this->inclusive('layer_type', $this->layer_type),
            'reference' => $this->inclusive('reference', $this->reference),
            'created_at' => $this->inclusive('created_at', $this->created_at),
            'updated_at' => $this->inclusive('updated_at', $this->updated_at),
        ];
    }
}
