<?php

namespace App\Http\Resources;

use App\DataTable\DataTableConfiguration;
use App\DataTable\DataTableResource;
use App\Models\InventoryAssembly;
use Illuminate\Http\Request;

class InventoryAssemblyResource extends DataTableResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        $this->loadMissing(DataTableConfiguration::getRequiredRelations(InventoryAssembly::class));

        return [
            'id' => $this->id,
            'warehouse' => $this->inclusive('warehouse', $this->whenLoaded('warehouse', function () {
                return ['id' => $this->warehouse->id, 'name' => $this->warehouse->name];
            })),
            'action_date' => $this->inclusive('action_date', $this->action_date),
            'action' => $this->inclusive('action', $this->action),
            'items' => $this->inclusive('items', $this->whenLoaded('inventoryAssemblyLines', function () {
                return InventoryAssemblyLineResource::collection($this->inventoryAssemblyLines);
            })),
            'created_at' => $this->inclusive('created_at', $this->created_at),
            'updated_at' => $this->inclusive('updated_at', $this->updated_at),
            'archived_at' => $this->inclusive('archived_at', $this->archived_at),
        ];
    }
}
