<?php

namespace App\Http\Resources;

use App\DataTable\DataTableResource;
use App\Models\InventoryAdjustment;
use Illuminate\Http\Request;

/**
 * Class InventoryAdjustmentResource.
 *
 *
 * @mixin InventoryAdjustment
 */
class InventoryAdjustmentResource extends DataTableResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        $parentClass = null;
        if ($parentLink = $this->getParentLink()) {
            $parentClass = get_class($parentLink);
        }

        return [
            'id' => $this->id,
            'adjustment_date' => $this->inclusive('adjustment_date', $this->adjustment_date),
            'product_id' => $this->inclusive('product_id', $this->product_id),
            'sku' => $this->inclusive('sku', $this->whenLoaded('product', function () {
                return $this->product->sku;
            })),
            'product_name' => $this->inclusive('product_name', $this->whenLoaded('product', function () {
                return $this->product->name;
            })),
            'product_average_cost' => $this->whenLoaded('product', function () {
                return $this->product->average_cost;
            }),
            'quantity' => $this->inclusive('quantity', $this->quantity),
            'warehouse' => $this->inclusive('warehouse', $this->whenLoaded('warehouse', function () {
                return $this->warehouse->only('id', 'name');
            })),
            'notes' => $this->inclusive('notes', $this->notes),

            'type' => $this->inclusive('type', $this->whenLoaded('link', function () use ($parentClass) {
                return [
                    'link_type' => $this->link_type,
                    'link_id' => $this->link_id,
                    'parent_link_type' => $parentClass,
                    'parent_link_id' => $this->parent_link_id, ];
            })),            '
          reference' => $this->inclusive('type', $this->whenLoaded('link', function () {
                return $this->link_id;
            })),
            'unit_cost' => $this->inclusive('unit_cost', $this->whenLoaded('fifoLayers', function () {
                return $this->unit_cost;
            })),
            'archived_at' => $this->inclusive('archived_at', $this->archived_at),
            'created_at' => $this->inclusive('created_at', $this->created_at),
            'updated_at' => $this->inclusive('updated_at', $this->updated_at),
        ];
    }
}
