<?php

namespace App\Http\Resources;

use App\Models\Integration;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/**
 * Class IntegrationResource.
 *
 *
 * @mixin Integration
 */
class IntegrationResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'integration_settings_template' => $this->integration_settings_template,
            'image_url' => $this->image_url,
            'country' => $this->country,
            'supports_multiple_instances' => $this->supports_multiple_instances,
            'integration_type' => $this->integration_type,
            'integration_sub_type' => $this->integration_sub_type,
            'last_sync' => $this->last_sync,
            'integration_instances' => IntegrationInstanceResource::collection($this->whenLoaded('integrationInstances')),
        ];
    }
}
