<?php

namespace App\Http\Resources;

use App\Models\IntegrationInstance;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/**
 * Class IntegrationInstanceResource.
 *
 *
 * @mixin IntegrationInstance
 */
class IntegrationInstanceResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {

        // Don't send access token over the wire.
        $connectionSettings = $this->connection_settings;
        if(isset($connectionSettings['access_token'])){
            unset($connectionSettings['access_token']);
        }

        return [
            'id'                   => $this->id,
            'integration_id'       => $this->integration_id,
            'integration'          => IntegrationResource::make($this->whenLoaded('integration')),
            'name'                 => $this->name,
            'connection_settings'  => $connectionSettings,
            'integration_settings' => $this->integration_settings,
            'sales_channel'        => $this->when(! is_null($this->salesChannel), $this->salesChannel),
            'store_mappings'       => $this->magentoMappings,
            'is_deleting'          => $this->when($connectionSettings['deleting'] ?? false, true),
            'is_automatic_sync_enabled'     => $this->is_automatic_sync_enabled,
        ];
    }
}
