<?php

namespace App\Http\Resources;

use App\DataTable\DataTableResource;
use Illuminate\Http\Request;

class IncotermResource extends DataTableResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'code' => $this->inclusive('code', $this->code),
            'id' => $this->id,
            'description' => $this->inclusive('description', $this->description),
            'created_at' => $this->inclusive('created_at', $this->created_at),
            'updated_at' => $this->inclusive('updated_at', $this->updated_at),
            'archived_at' => $this->inclusive('archived_at', $this->archived_at),
        ];
    }
}
