<?php

namespace App\Http\Resources\Financials;

use App\Models\Product;
use App\Models\ReportingDailyFinancial;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/**
 * Class TopProductResource.
 *
 * @mixin ReportingDailyFinancial
 *
 * @property float $total_revenue
 * @property float $total_cost
 * @property float $total_profit
 */
class TopProductResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        /** @var Product $product */
        $product = $this->product;

        return [
            'product' => [
                'id' => $product->id,
                'name' => $product->name,
                'sku' => $product->sku,
                'image_url' => $product->image,
                'brand' => $this->when($product->brand, function () use ($product) {
                    return [
                        'id' => $product->brand_id,
                        'name' => $product->brand->name,
                    ];
                }),
            ],
            'quantity_sold' => ! is_null($this->quantity) ? $this->quantity : $this->quantity_sold,
            'revenue' => $this->total_revenue,
            'costs' => $this->total_cost,
            'profit' => $this->total_profit,
            'num_orders' => $this->num_orders,
        ];
    }
}
