<?php

namespace App\Http\Resources;

use App\DataTable\DataTableResource;
use Illuminate\Http\Request;

class DataFeedResource extends DataTableResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'name' => $this->inclusive('name', $this->name),
            'type' => $this->inclusive('type', $this->type),
            'data_direction' => $this->inclusive('data_direction', $this->data_direction),
            'connection_type' => $this->inclusive('connection_type', $this->connection_type),
            'connection_settings' => $this->inclusive('connection_settings', $this->connection_settings),
            'field_settings' => $this->inclusive('field_settings', $this->field_settings),
            'filters' => $this->inclusive('filters', $this->filters),
            'schedule' => $this->inclusive('schedule', $this->schedule),
            'processed_at' => $this->inclusive('processed_at', $this->processed_at),
            'created_at' => $this->inclusive('processed_at', $this->created_at),
            'updated_at' => $this->inclusive('processed_at', $this->updated_at),
            'archived_at' => $this->inclusive('processed_at', $this->updated_at),
        ];
    }
}
