<?php

namespace App\Http\Resources;

use App\Models\SalesOrder;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/**
 * Class CustomerUnpaidOrderResource.
 *
 * @mixin SalesOrder
 */
class CustomerUnpaidOrderResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'sales_order_number' => $this->sales_order_number,
            'due_date' => $this->deliver_by_date,
            'amount' => (float) $this->total,
            'paid' => (float) $this->total_paid,
        ];
    }
}
