<?php

namespace App\Http\Resources;

use App\DataTable\DataTableResource;
use Illuminate\Http\Request;

class CustomerResource extends DataTableResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'name' => $this->inclusive('name', $this->name),
            'id' => $this->id,
            'email' => $this->inclusive('email', $this->email),
            'sales_channel_origin' => $this->inclusive('sales_channel_origin', $this->whenLoaded('salesChannelOrigin', function () {
                return $this->salesChannelOrigin->only('id', 'name');
            })),
            'created_at' => $this->inclusive('created_at', $this->created_at),
            'updated_at' => $this->inclusive('updated_at', $this->updated_at),
            'archived_at' => $this->inclusive('archived_at', $this->archived_at),
            'address1' => $this->inclusive('address1', $this->address1),
            'company_name' => $this->inclusive('company_name', $this->company),
            'phone' => $this->inclusive('phone', $this->phone),
            'zip' => $this->inclusive('zip', $this->zip),
            'fax' => $this->inclusive('fax', $this->fax),

            $this->mergeWhen($this->resource->relationLoaded('address'), function () {
                return [
                    'address2' => $this->inclusive('address2', $this->address->address2 ?? null),
                    'address3' => $this->inclusive('address3', $this->address->address3 ?? null),
                    'city' => $this->inclusive('city', $this->address->city ?? null),
                    'province' => $this->inclusive('province', $this->address->province ?? null),
                    'province_code' => $this->inclusive('province_code', $this->address->province_code ?? null),
                    'country' => $this->inclusive('country', $this->address->country ?? null),
                    'country_code' => $this->inclusive('country_code', $this->address->country_code ?? null),
                ];
            }),

            'addresses' => $this->all_addresses,
            //      $this->mergeWhen( $this->resource->relationLoaded( 'billingAddress' ), function () {
            //        return [
            //          'default_billing_address' => $this->billingAddress,
            //        ];
            //      } ),
            //
            //      $this->mergeWhen( $this->resource->relationLoaded( 'address' ), function () {
            //        return [
            //          'default_shipping_address' => $this->shippingAddress,
            //        ];
            //      } ),
            //
            //      $this->mergeWhen( $this->resource->relationLoaded( 'addresses' ), function () {
            //        return [
            //          'other_addresses' => $this->addresses->map( function ( Address $address ) { return collect( $address )->except( 'pivot' ); } ),
            //        ];
            //      } ),

            // Default Settings

            'default_pricing_tier' => $this->whenLoaded('productPricingTier', function () {
                return $this->productPricingTier->only('id', 'name');
            }),
            'default_store' => $this->whenLoaded('store', function () {
                return $this->store->only('id', 'name');
            }),
            'default_shipping_method_domestic' => $this->whenLoaded('shippingMethodDomestic', function () {
                return $this->shippingMethodDomestic->only('id', 'name');
            }),
            'default_shipping_method_international' => $this->whenLoaded('shippingMethodInternational', function () {
                return $this->shippingMethodInternational->only('id', 'name');
            }),
            'default_warehouse' => $this->whenLoaded('warehouse', function () {
                return $this->warehouse->only('id', 'name');
            }),
        ];
    }
}
