<?php

namespace App\Http\Resources;

use App\Models\SalesCredit;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/**
 * Class CustomerOpenSalesCreditResource.
 *
 * @mixin SalesCredit
 */
class CustomerOpenSalesCreditResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'sales_credit_number' => $this->sales_credit_number,
            'credit_date' => $this->credit_date,
            'total_credit' => $this->total_credit,
            'paid_amount' => $this->paid_amount,
        ];
    }
}
