<?php

namespace App\Http\Resources;

use App\DataTable\DataTableResource;
use Illuminate\Http\Request;

class CsvTemplateResource extends DataTableResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'name' => $this->inclusive('name', $this->name),
            'id' => $this->id,
            'template_type' => $this->inclusive('template_type', $this->model),
            'columns' => $this->inclusive('columns', $this->columns),
            'used_count' => $this->inclusive('used_count', $this->used_count),
            'last_import' => $this->inclusive('last_import', $this->last_imported_at),
            'last_export' => $this->inclusive('last_export', $this->last_exported_at),
            'create_at' => $this->inclusive('created_at', $this->created_at),
            'updated_at' => $this->inclusive('updated_at', $this->updated_at),
            'archived_at' => $this->inclusive('archived_at', $this->archived_at),
        ];
    }
}
