<?php

namespace App\Http\Resources;

use App\DataTable\DataTableResource;
use App\Models\BackorderQueue;
use Illuminate\Http\Request;

/**
 * Class BackorderQueueResource.
 *
 * @mixin BackorderQueue
 */
class BackorderQueueResource extends DataTableResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'priority' => $this->inclusive('priority', $this->priority),
            'backorder_date' => $this->inclusive('backorder_date', $this->backorder_date),
            'sku' => $this->inclusive('sku', $this->whenLoaded('salesOrderLine', function () {
                return [
                    'id' => $this->salesOrderLine->product_id,
                    'sku' => $this->salesOrderLine->product->sku ?? null,
                ];
            })),
            'product_name' => $this->inclusive('product_name', $this->whenLoaded(
                'salesOrderLine',
                $this->salesOrderLine->product->name ?? null
            )),
            'backordered_quantity' => $this->inclusive('backordered_quantity', $this->backordered_quantity),
            'released_quantity' => $this->inclusive('released_quantity', $this->released_quantity),
            'supplier' => $this->inclusive('supplier', $this->whenLoaded('supplier', function () {
                return [
                    'id' => $this->supplier->id,
                    'name' => $this->supplier->name,
                ];
            })),
            'sales_order_number' => $this->inclusive('sales_order_number', $this->whenLoaded('salesOrderLine', function () {
                return [
                    'sales_order_line_id' => $this->salesOrderLine->id,
                    'sales_order_id' => $this->salesOrderLine->salesOrder->id,
                    'sales_order_number' => $this->salesOrderLine->salesOrder->sales_order_number,
                ];
            })),
            'purchase_order_numbers' => $this->inclusive('purchase_order_numbers', $this->whenLoaded('backorderQueueCoverages', function () {
                return BackorderQueueCoverageResource::collection($this->backorderQueueCoverages);
            })),
            'covered_by_po' => $this->covered_by_po,
            'scheduled_at' => $this->inclusive('scheduled_at', $this->scheduled_at),
            'created_at' => $this->inclusive('created_at', $this->created_at),
            'updated_at' => $this->inclusive('updated_at', $this->updated_at),
            'archived_at' => $this->inclusive('archived_at', $this->archived_at),
        ];
    }
}
