<?php

namespace App\Http\Resources;

use App\DataTable\DataTableResource;
use App\Models\BackorderQueueCoverage;
use Illuminate\Http\Request;

/**
 * Class BackorderQueueCoverageResource.
 *
 * @mixin BackorderQueueCoverage
 */
class BackorderQueueCoverageResource extends DataTableResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        $this->loadMissing(['purchaseOrderLine', 'backorderQueue']);

        return [
            'id' => $this->id,
            'purchase_order' => [
                'purchase_order_line_id' => $this->purchaseOrderLine->id,
                'purchase_order_id' => $this->purchaseOrderLine->purchaseOrder->id,
                'covered_quantity' => $this->covered_quantity,
                'released_quantity' => $this->released_quantity,
                'purchase_order_number' => $this->purchaseOrderLine->purchaseOrder->purchase_order_number,
                'eta' => $this->purchaseOrderLine->purchaseOrder->estimated_delivery_date,
                'received_at' => $this->purchaseOrderLine->purchaseOrder->fully_received_at ?? $this->purchaseOrderLine->last_receipt_date,
            ],
            'sales_order' => [
                'sales_order_line_id' => $this->backorderQueue->sales_order_line_id,
                'sales_order_id' => $this->backorderQueue->salesOrderLine->sales_order_id,
                'sales_order_number' => $this->backorderQueue->salesOrderLine->salesOrder->sales_order_number,
            ],
            'backorder_queue' => [
                'id' => $this->backorder_queue_id,
                'priority' => $this->backorderQueue->priority,
                'backordered_quantity' => $this->backorderQueue->backordered_quantity,
                'released_quantity' => $this->backorderQueue->released_quantity,
                'covered_quantity' => $this->backorderQueue->backorderQueueCoverages->sum('unreleased_quantity'),
            ],
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
