<?php

namespace App\Http\Requests;

use App\Models\ProductListing;
use Illuminate\Foundation\Http\FormRequest;

class UpdateProductListing extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        return [
            'master_of_price' => 'nullable|in:'.implode(',', ProductListing::MASTERS),
            'product_pricing_tier_id' => 'nullable|required_if:master_of_price,'.ProductListing::MASTER_SKU.'|exists:product_pricing_tiers,id',
            'master_of_stock' => 'nullable|in:'.implode(',', ProductListing::MASTERS),
            'fulfillment_latency' => 'numeric',
            'inventory_rules' => 'nullable|array',
            'proforma_marketplace_cost_percentage' => 'nullable|numeric',
        ];
    }
}
