<?php

namespace App\Http\Requests\TaxRate;

use Illuminate\Foundation\Http\FormRequest;

class StoreTaxRateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        return [
            'name' => 'required',
            'rate' => 'required|numeric',
            'accounting_integration_id' => 'numeric',
            'accounting_integration_type' => 'string',
            'tax_rate_lines.*.name' => 'required',
            'tax_rate_lines.*.rate' => 'required|numeric',
        ];
    }
}
