<?php

namespace App\Http\Requests;

use App\Models\SupplierInventory;
use App\Validator;
use Illuminate\Foundation\Http\FormRequest;

class SupplierInventoryRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        $rules = [
            'supplier_id' => 'required|exists:suppliers,id',
            'product_id' => 'required|exists:products,id',
            'warehouse_id' => 'required|exists:warehouses,id',
            'quantity' => 'required_without:in_stock',
            'in_stock' => 'required_without:quantity|boolean|nullable',
            'discontinued' => 'boolean',
            'eta' => 'nullable|date',
            'source' => 'required|in:'.implode(',', SupplierInventory::SOURCES),
        ];

        if ($this->isMethod('put')) {
            $rules['supplier_id'] = 'sometimes|'.$rules['supplier_id'];
            $rules['product_id'] = 'sometimes|'.$rules['product_id'];
            $rules['warehouse_id'] = 'sometimes|'.$rules['warehouse_id'];
            $rules['source'] = 'sometimes|in:'.implode(',', SupplierInventory::SOURCES);
        }

        return $rules;
    }

    public function withValidator(Validator $validator)
    {
        if ($validator->passes()) {
            $validator->after(function (Validator $validator) {
                $attributes = $validator->attributes();

                if (! empty($attributes['quantity']) && (! is_numeric($attributes['quantity']) || $attributes['quantity'] < 0)) {
                    $validator->addFailure('quantity', 'MustBeNonNegativeNumber');
                }
            });
        }
    }

    public function messages(): array
    {
        return [
            'must_be_non_negative_number' => 'quantity must be non-negative number',
            'must_be_true_or_false' => 'in_stock must be true or false.',
        ];
    }
}
