<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class StoreSupplierProduct extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        $rules = [
            'supplier_id' => 'required|exists:suppliers,id',
            'product_id' => [
                'required',
                'exists:products,id',
                Rule::unique('supplier_products', 'product_id')
                    ->where('supplier_id', $this->input('supplier_id'))
                    ->whereNot('id', $this->route('supplier_product')),
            ],

            'supplier_sku' => [
                'nullable',
                'max:255',
                Rule::unique('supplier_products', 'supplier_sku')
                    ->where('supplier_id', $this->input('supplier_id'))
                    ->whereNot('id', $this->route('supplier_product')),
            ],

            'leadtime' => 'nullable|integer',
            'minimum_order_quantity' => 'nullable|numeric|lt:1000000',
            'is_default' => 'boolean',
            'default_tax_rate_id' => 'nullable|exists:tax_rates,id',
        ];

        if ($this->isMethod('put')) {
            $rules['supplier_id'] = 'nullable|exists:suppliers,id';
            $rules['product_id'][0] = 'nullable';
        }

        return $rules;
    }

    public function messages(): array
    {
        return [
            'product_id.unique' => __('messages.supplier.product_id_exists'),
            'supplier_sku.unique' => __('messages.supplier.supplier_sku_exists'),
        ];
    }
}
