<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class StoreProductImages extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        return [
            'images' => 'present|array',
            'images.*.id' => [
                'nullable',
                Rule::exists('product_images', 'id')->where('product_id', $this->route()->originalParameter('product')),
            ],
            'images.*.url' => 'required_without:images.*.id|string',
            'images.*.name' => 'nullable|max:255',
            'images.*.sort_order' => 'nullable|integer',
            'images.*.download' => 'nullable|boolean',
            'images.*.is_primary' => 'nullable|boolean',
        ];
    }
}
