<?php

namespace App\Http\Requests;

use App\Models\DataFeed;
use Illuminate\Foundation\Http\FormRequest;

class StoreDataFeedRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        $rules = [
            'name' => [
                'required',
                'max:255',
            ],
            'type' => [
                'required',
                'in:'.implode(',', DataFeed::TYPES),
            ],
            'data_direction' => [
                'required',
                'in:'.implode(',', DataFeed::DATA_DIRECTIONS),
            ],
            'connection_type' => [
                'required',
                'in:'.implode(',', DataFeed::CONNECTION_TYPES),
            ],
            'connection_settings' => [
                'array',
            ],
            'field_settings' => [
                'array',
            ],
            'filters' => [
                'array',
            ],
            'schedule' => [
                'array',
            ],
        ];

        return $rules;
    }
}
