<?php

namespace App\Http\Requests;

use App\Models\PurchaseInvoice;
use Illuminate\Foundation\Http\FormRequest;

class StoreCustomPurchaseInvoice extends FormRequest
{
    use BindsRequiredRules;

    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        $rules = [
            'purchase_order_id' => 'exists:purchase_orders,id',
            'purchase_invoice_date' => 'date',
            'supplier_invoice_number' => 'max:255',
            'supplier_id' => 'exists:suppliers,id',
            'status' => 'in:'.implode(',', PurchaseInvoice::STATUS),
            'total' => 'numeric:min:1',
            'description' => 'max:255',
        ];

        if ($this->getMethod() === 'POST') {
            $rules = $this->bindRequiredRules($rules);
        }

        return $rules;
    }

    public function requiredOnStore()
    {
        return [
            'purchase_order_id',
            'purchase_invoice_date',
            'supplier_invoice_number',
            'supplier_id',
            'status',
            'total',
            'description',
        ];
    }
}
