<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ReportTemplateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        $rules = [
            'name' => 'required',
            'content' => 'required|array',
        ];

        if ($this->isMethod('put')) {
            $rules['name'] = 'sometimes|'.$rules['name'];
            $rules['content'] = 'sometimes|'.$rules['content'];
        }

        return $rules;
    }
}
