<?php

namespace App\Http\Requests;

use App\Services\PurchaseOrder\PurchaseOrderBuilder\Builders\SalesBasedPurchaseOrderBuilder;
use App\Services\PurchaseOrder\PurchaseOrderBuilder\PurchaseOrderBuilderFactory;
use Illuminate\Foundation\Http\FormRequest;

class PurchaseOrderBuilderRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        return [
            'supplier_id' => 'required|exists:suppliers,id',
            'destination_warehouse_id' => 'required_unless:forecast_type,'.PurchaseOrderBuilderFactory::BUILDER_TYPE_WITH_SALES_HISTORY.'|exists:warehouses,id',
            'forecast_type' => 'required|in:'.implode(',', PurchaseOrderBuilderFactory::SUPPORTED_BUILDER_TYPES),
            'pricing_tier_id' => 'nullable|exists:supplier_pricing_tiers,id',
            'purchase_order_id' => 'nullable|exists:supplier_pricing_tiers,id',
            'options' => 'required|array',
            'options.quantity' => 'required_if:forecast_type,'.PurchaseOrderBuilderFactory::BUILDER_TYPE_TARGET_STOCK_LEVEL.'|numeric|min:0',
            'options.rounding_method' => 'nullable|in:'.implode(',', SalesBasedPurchaseOrderBuilder::ROUNDING_METHODS),
            'options.product_filters' => 'nullable|array',
            'options.sales_history_filters' => 'nullable|array',
            'options.use_leadtime' => 'nullable|boolean',
            'options.use_moq' => 'nullable|boolean',
            'options.sales_start_date' => 'required_if:forecast_type,'.PurchaseOrderBuilderFactory::BUILDER_TYPE_WITH_SALES_HISTORY.'|date|before:tomorrow|before_or_equal:options.sales_end_date',
            'options.sales_end_date' => 'required_if:forecast_type,'.PurchaseOrderBuilderFactory::BUILDER_TYPE_WITH_SALES_HISTORY.'|date|after_or_equal:options.sales_start_date',
            'options.target_stock_days' => 'required_if:forecast_type,'.PurchaseOrderBuilderFactory::BUILDER_TYPE_WITH_SALES_HISTORY.'|integer|min:1',
        ];
    }
}
