<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class MapShipstationWarehouseRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            'mapping' => 'required|array',
            'mapping.*.warehouse_id' => 'required|exists:warehouses,id',
            'mapping.*.shipstation_warehouse_id' => 'required|exists:shipstation_warehouses,id'
        ];
    }
}
