<?php

namespace App\Http\Requests;

use App\Importers\Parsers\FieldParserFactory;
use App\Models\Product;
use Illuminate\Foundation\Http\FormRequest;

class ListingsToSkuProductsRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        $rules = [
            'filters' => 'required_without_all:listings,ids,initial_mapping',
            'listings' => 'required_without_all:filters,ids,initial_mapping|array|min:1',
            'listings.*.sku' => 'required|unique:products,sku',
            'listings.*.name' => 'required',
            'listings.*.brand_name' => 'nullable|max:255',
            'listings.*.type' => 'nullable|in:'.implode(',', Product::TYPES),
            'listings.*.price' => 'nullable|numeric',
            'listing.*.images' => 'array',
            'listing.*.images.*.url' => 'required',
            'listing.*.images.*.name' => 'nullable|max:255',
            'listing.*.images.*.sort_order' => 'nullable|integer',
            'listing.*.images.*.download' => 'nullable|boolean',
            'listing.*.images.*.is_primary' => 'nullable|boolean',
            'mapping' => 'nullable|array',
            'mapping.*.listing_field' => 'required',
            'mapping.*.sku_field' => 'required',
            'mapping.*.parsers' => 'nullable|array',
            'mapping.*.parsers.*.rule' => 'required|in:'.implode(',', FieldParserFactory::SUPPORTED_PARSERS),
            'mapping.*.parsers.*.args' => 'required',
            'initial_mapping' => 'nullable',
        ];

        // ids validation rule
        $modelPath = $this->route('integration_instance')->integration->getProductsModelPath();
        $modelInstance = new $modelPath();
        $table = $modelInstance->getTable().',id';

        $rules['ids.*'] = "required_without_all:filters,listings|exists:{$table}";

        return $rules;
    }
}
