<?php

namespace App\Http\Requests;

use Illuminate\Contracts\Validation\ValidationRule;
use Illuminate\Foundation\Http\FormRequest;

class ForecastPurchaseOrdersRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'purchase_orders' => 'required|array',
            'purchase_orders.*.supplier_id' => 'required|exists:suppliers,id',
            'purchase_orders.*.purchase_order_lines' => 'required|array',
            'purchase_orders.*.purchase_order_lines.*.forecast_item_id' => 'required|exists:inventory_forecast_items,id',
            'purchase_orders.*.purchase_order_lines.*.product_id' => 'required|exists:products,id',
            'purchase_orders.*.purchase_order_lines.*.quantity' => 'required|numeric|min:1',
            'purchase_orders.*.purchase_order_lines.*.amount' => 'required|numeric|min:0',
            'purchase_orders.*.purchase_order_lines.*.description' => 'required|max:255',
        ];
    }
}
