<?php

namespace App\Http\Requests\Connection;

use Illuminate\Foundation\Http\FormRequest;

class CheckFtpConnectionRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        return [
            'ftp_host' => [
                'required',
            ],
            'ftp_username' => [
                'required',
            ],
            'ftp_password' => [
                'required',
            ],
            'ftp_port' => [
                'required',
                'integer',
            ],
            'ftp_timeout' => [
                'integer',
            ],
            'ftp_is_sftp' => [
                'required',
                'boolean',
            ],
        ];
    }
}
