<?php

namespace App\Http\Requests\CompanyProfile;

use Illuminate\Foundation\Http\FormRequest;

class UpdateCompanyProfileRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return auth()->user()->is_admin;
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        return [
            'name' => ['sometimes'],
            'email' => ['sometimes'],
            'phone' => ['sometimes'],
            'country' => ['sometimes'],
            'zip' => ['sometimes'],
            'city' => ['sometimes'],
            'state_province' => ['sometimes'],
            'address_lines' => ['sometimes'],
        ];
    }
}
