<?php

namespace App\Http\Requests\Auth;

use App\Rules\CheckUserPasswordRule;
use Illuminate\Foundation\Http\FormRequest;

class UpdatePasswordRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        return [
            'old_password' => ['required', 'string', new CheckUserPasswordRule],
            'password' => ['required', 'string', 'min:8', 'confirmed'],
        ];
    }
}
