<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpKernel\Exception\UnauthorizedHttpException;

/**
 * This Middleware for common api routes between differences authentications (api, basic or oauth in future).
 *
 * Class CommonAuthenticate
 */
class CommonAuthenticate
{
    /**
     * Handle an incoming request.
     */
    public function handle(Request $request, Closure $next): Response
    {
        /**
         * Check Basic authentication then set user to web guard (if we want to use it).
         */
        // Get basic credentials from request.
        $credentials = ['key' => $request->getUser(), 'password' => $request->getPassword()];

        // Check credentials and authenticate
        if (auth('basic')->once(array_merge($credentials, []))) {
            /**
             * Set authenticated user to "web" guard auth.
             */
            auth()->setUser(auth('basic')->user()->user);

            return $next($request);
        }

        /**
         * Check api (bearer) authentication then set user to web guard (if we want to use it).
         */
        // Get user by request.
        if (auth('api')->setRequest($request)->user()) {
            /**
             * Authenticate and set authenticated user to "web" guard auth.
             */
            auth('api')->authenticate($request);

            // set user to "web" guard auth
            auth()->setUser(auth('api')->user());

            return $next($request);
        }

        /**
         * If not authorized from all guards.
         */
        throw new UnauthorizedHttpException('Unauthorized from all guards');
    }
}
