<?php

namespace App\Http\Controllers;

use App\Uploader\Uploader;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\BinaryFileResponse;

/**
 * Class UploadController.
 */
class UploadController extends Controller
{
    /**
     * @var Uploader
     */
    private $uploader;

    /**
     * UploadController constructor.
     */
    public function __construct(Uploader $uploader)
    {
        parent::__construct();
        $this->uploader = $uploader;
    }

    public function upload(Request $request): JsonResponse
    {
        try {
            $result = $this->uploader->upload($request->file('file'), $request->get('destination'));

            return response()->json($result, 200);
        } catch (\Throwable $e) {
            return response()->json([])->setStatusCode(500, $e->getMessage());
        }
    }

    public function download(Request $request): BinaryFileResponse
    {
        return response()->download($this->uploader->getFilePath($request->input('file'), $request->get('destination')));
    }
}
