<?php

namespace App\Http\Controllers;

use App\DataTable\DataTable;
use App\Http\Resources\TrackedJobLogResource;
use App\Models\TrackedJobLog;
use Illuminate\Http\JsonResponse;
use ReflectionClass;
use ReflectionException;

class TrackedJobLogController extends Controller
{
    use DataTable;

    /**
     * @throws ReflectionException
     */
    public function retry(TrackedJobLog $trackedJobLog): JsonResponse
    {
        $jobClass = $trackedJobLog->job_type;
        $serializedArgs = json_decode($trackedJobLog->job_data, true);
        $deserializedArgs = $this->deserializeArguments($serializedArgs);

        // Create a new instance of the job using reflection (for dynamic arguments)
        $reflectionClass = new ReflectionClass($jobClass);
        $jobInstance = $reflectionClass->newInstanceArgs($deserializedArgs);

        // Dispatch the recreated job instance
        dispatch($jobInstance)->onQueue($trackedJobLog->queue);

        // Return success
        return response()->json([
            'message' => 'Job has been requeued.',
        ]);
    }

    protected function deserializeArguments(array $serializedArgs)
    {
        return array_map(function ($argument) {
            if (is_array($argument) && $argument['type'] === 'eloquent_model') {
                return ($argument['model'])::find($argument['id']);
            }

            // ... handle other complex types as needed ...

            return $argument;
        }, $serializedArgs);
    }

    protected function getModel()
    {
        return TrackedJobLog::class;
    }

    protected function getResource()
    {
        return TrackedJobLogResource::class;
    }
}
