<?php

namespace App\Http\Controllers;

use App\Data\FinancialLineData;
use App\Models\FinancialLine;
use App\Models\SalesOrder;
use App\Repositories\FinancialLineRepository;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class SalesOrderFinancialLineController extends Controller
{
    private FinancialLineRepository $financialLineRepository;

    public function __construct()
    {
        parent::__construct();
        $this->financialLineRepository = app(FinancialLineRepository::class);
    }

    public function store(Request $request, SalesOrder $salesOrder)
    {
        $inputs = $request->validate(FinancialLineData::rules());

        return $salesOrder->financialLines()->create($inputs);
    }

    public function update(Request $request, SalesOrder $salesOrder, FinancialLine $financialLine)
    {
        $inputs = $request->validate(FinancialLineData::rules());

        return $financialLine->update(FinancialLineData::from($inputs)->toArray());
    }

    public function index(SalesOrder $salesOrder)
    {
        return $this->financialLineRepository->query($salesOrder);
    }

    public function destroy(SalesOrder $salesOrder, FinancialLine $financialLine): Response
    {
        $financialLine->delete();

        return response()->noContent();
    }
}
