<?php

namespace App\Http\Controllers;

use App\Models\Product;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class ProductAttributeController extends Controller
{
    /**
     * Update or Add attributes to product.
     */
    public function update(Request $request, $productId): JsonResponse
    {
        $request->validate(
            [
                'attributes' => 'required|array',
                'attributes.*.id' => 'required_without:attributes.*.name|exists:attributes,id',
                'attributes.*.name' => 'required_without:attributes.*.id|max:255',
                'attributes.*.value' => 'nullable',
            ]
        );

        // Syncing attributes without detach other existing attribute IDs.
        $product = Product::with([])->findOrFail($productId);
        $product->setProductAttributes($request->input('attributes'), false);

        return $this->response->setMessage(__('messages.success.update', ['resource' => 'product attributes']));
    }

    /**
     * Delete attributes from product.
     */
    public function delete(Request $request, $productId): JsonResponse
    {
        $request->validate(
            [
                'attributes' => 'required|array|min:1',
                'attributes.*' => 'exists:attributes,id',
            ]
        );

        /**
         * Detach attribute IDs.
         */
        $product = Product::with([])->findOrFail($productId);
        $product->productAttributes()->detach($request->input('attributes'));

        return $this->response->setMessage(__('messages.success.delete', [
            'resource' => 'product attributes',
            'id' => implode(',', $request->input('attributes')),
        ]));
    }
}
