<?php

namespace App\Http\Controllers;

use App\Data\NoteData;
use App\Models\Note;
use App\Response;

class NoteController extends Controller
{
    public function store(NoteData $note): Response
    {
        $model = app($note->link_type)::find($note->link_id);

        $note  = $model->notes()->create($note->toArray());

        $note->load('user');

        return $this->response->addData($note)
            ->setMessage(__('messages.success.create', ['resource' => 'note']));
    }

    public function destroy(Note $note): Response
    {
        $note->delete();

        return $this->response->setMessage(__('messages.success.delete', ['resource' => 'note', 'id' => $note->id]));
    }

}
