<?php

namespace App\Http\Controllers\Magento;

use App\Http\Controllers\Controller;
use App\Models\Magento\ProductAttribute;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ProductAttributeController extends Controller
{
    public function index(Request $request, $integrationInstanceId)
    {
        $builder = ProductAttribute::query()->where('integration_instance_id', $integrationInstanceId);
        if (! empty($query = $request->get('query'))) {
            $builder->where(function (Builder $builder) use ($query) {
                $builder->where('code', 'like', "%$query%");
                $builder->orWhere('label', 'like', "%$query%");
            });
        }

        // all attributes
        if ($request->input('limit') == -1) {
            return JsonResource::collection($builder->get());
        }

        return JsonResource::collection($builder->paginate());
    }
}
