<?php

namespace App\Http\Controllers\Magento;

use App\Enums\DownloadedBy;
use App\Http\Controllers\Controller;
use App\Jobs\Magento\GetOrdersJob;
use App\Models\IntegrationInstance;
use App\Response;
use Illuminate\Http\Request;

class OrderController extends Controller
{
    /**
     * Download Magento Orders by increment_id
     */
    public function download(Request $request, IntegrationInstance $integrationInstance): Response
    {
        $request->validate(['increment_ids' => 'required|array|min:1']);

        dispatch_sync(new GetOrdersJob($integrationInstance, ['ids' => $request->input('increment_ids'), 'downloaded_by' => DownloadedBy::Command]));

        return $this->response->setMessage(__('messages.success.download', ['resource' => 'magento orders']));
    }
}
